/*------------------------------------------------------------------------------*
 * File Name: utilities.h														*
 * Creation: CPY 3/1/2001														*
 * Purpose: Origin C internal utility classes									*
 * Copyright (c) OriginLab Corp.2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 05-19-2004 v7.5875 QA70-6426 GET_LICENSE_INFO_FROM_OC					*
 *	ML 9/15/2004 QA70-5770 QA70-6878 ANALYSIS_MENUS_OC_HANDLING					*
 * EJP 2005-02-28 v8.0198 QA70-7433 IMPORT_CSV_FILES							*
 * DSC 8/8/05 QA70-7973 EXPORT_CVT_STR_TO_DOUBLE_AS_ATOF						*
 *	ML 1/13/2006 XVARIABLEBASE_TO_VC											*
 *	ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION							*
 *	Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY							*
 * Sim 04-18-2007 FIX_PROGRESS_CANCEL_ISSUE										*
 *	ML 3/18/2008 QA70-10598 FORCE_REPORT_TO_ENGLISH								*
 *	ML 11/17/2008 NASTY_FLOATING_PROCESSOR_EXCEPTION_TROUBLES_DUE_TO_CALL_IN_C_TO_RETURN_DOUBLE_FUNCTION_FILE_WITHOUT_DECLARATION_BEING_SEEN
 *	Folger 12/17/08 QA80-12749 v8.0987d PLOT_MRU_LIST_SHOULD_UPDATE_THAT_PLOTS_IN_TEMPLATE_LIBRARY
 *	Kyle 03/03/2009 QA80-13149 RoundBinningRange_SUPPORT_SPECIFYING_INCREMENT	*
 *	Kyle 09/18/2009 QA80-14216 GET_OPTIONAL_MESSAGE_STATUS						*
 *	Folger 11/10/09 OC_PROGRESSBAR_NEEDS_SUPPORT_REOPEN							*
 *	Kenny 12/24/2009 QA81-14875-P2 PROGRESS_BAR_IN_BUILTIN_TOOL_SHOULD_NOT_KEEP_TOPMOST*
 *	Folger 12/11/09 QA81-14831-P1 LT_USE_OC_GETN_SUPPRESS_ERROR_WHEN_USER_CANCEL*
 *	Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT				*
 *	DSC 2/08/2010 DEL_OCTEMP_WHEN_INSTALL_MODULE_DEVELOPERKIT_LIC				*
 *	ML 2/12/2010 QA70-15113 FORMAT_MENU_UPDATE_ON_INSTALLING_OMC				*
 *	Folger 02/22/10 CENTRALIZE_CODE_ABOUT_OC_VARIABLE_TEMP_CHANGE				*
 *	Folger 02/26/10 QA81-14568-P2 CHANGE_UFF_BETTER_ERROR_CHECKING				*
 *	Folger 03/22/10 QA81-14867 BATCH_PROCESS_TOO_MANY_FILES_THAT_FILL_UP_MESSAGE_QUEUE_CRASH_ORIGIN
 *	Kyle 05/04/2010 QA80-15378 OC_FUNCTION_TO_CONVERT_BETWEEN_FONT_INDEX_AND_DWORD
 *	Folger 06/12/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT						*
 *	Folger 07/14/10 ORG-518-P10 PROPER_ERROR_REPORT_FOR_FFW_QUICK_CHECK			*
 *	Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
 *------------------------------------------------------------------------------*/

#ifndef _UTILITIES_H
#define _UTILITIES_H

#include <common.h> // must always include this
#include <mswin.h> // kernel32 functions

#ifndef _STRING_H
#include <string.h> // String Class
#endif // _STRING_H

#ifndef _DATA_H
#include <data.h>   //Dataset handling classes(vector, Dataset, matrix, Matrix ...)
#endif // _DATA_H
//---- CPY 8/14/06 temp, cannot compile Sandy's change, put this here for now, should really be some centralized place
typedef struct tagPALETTEENTRY {
    BYTE        peRed;
    BYTE        peGreen;
    BYTE        peBlue;
    BYTE        peFlags;
} PALETTEENTRY;
//----
///Comments last updated by Joseph on 03/12/2007
//#include <mscomm.h>
/**$ >Utility
		Helper class for saving and restore of a LabTalk variable, most useful for system variables.
	Example1:
		void ascii_import_hide_progress_bar()
		{
			Worksheet wks = Project.ActiveLayer();
			if(!wks)
				return;
			ASCIMP ai;
			wks.GetASCIMP(ai);
			
			string strFile = GetOpenBox("*.txt");
			if(strFile.IsEmpty())
				return;
			
			ASCIMPRESULT air;
			LTVarTempChange junk("@NPO", 0); // set to 0 to hide progress bar
			DWORD dw = GetTickCount();
			int nRet = wks.ImportASCII(strFile, ai, &air);
			printf("import time = %f sec\n", (GetTickCount()-dw)/1000.);
		}
*/
class LTVarTempChange
{
public:
	// Comments last updated by Iris on 03/12/2007
	/**
	Parameters:
		lpcszName=The name of Labtalk variable
		dTempVal=The value want to change.
	*/
	LTVarTempChange(LPCSTR lpcszName, double dTempVal)
	{
		string strLT;
		m_strVar = lpcszName;
		LT_get_var(m_strVar, &m_dOldVal);
		LT_set_var(m_strVar, dTempVal);
	}
	~LTVarTempChange()
	{
		LT_set_var(m_strVar, m_dOldVal);
	}
private:
	double m_dOldVal;
	string m_strVar;
};

///------ Folger 03/22/10 QA81-14867 BATCH_PROCESS_TOO_MANY_FILES_THAT_FILL_UP_MESSAGE_QUEUE_CRASH_ORIGIN
#define		OC_POST_MESSAGE_BREAKER(_dw)			LTVarTempChange  _aum("@AUM", 2.0), _pmb("@PMB", _dw)
///------ End BATCH_PROCESS_TOO_MANY_FILES_THAT_FILL_UP_MESSAGE_QUEUE_CRASH_ORIGIN

///------ Folger 02/22/10 CENTRALIZE_CODE_ABOUT_OC_VARIABLE_TEMP_CHANGE
#define		OCVarTempChange(_TYPE)		OCVarTempChange##_TYPE

#define		DECLARE_OCVarTempChange(_TYPE) \
			class OCVarTempChange(_TYPE) \
			{ \
			public: \
				OCVarTempChange##_TYPE(_TYPE& _val, _TYPE _newVal) \
				{ \
					m_oldVal = _val; \
					_val = _newVal; \
					m_pVal = &_val; \
				} \
				~OCVarTempChange##_TYPE() \
				{ \
					*m_pVal = m_oldVal;\
				} \
			private: \
				_TYPE		m_oldVal; \
				_TYPE*		m_pVal; \
			};

/// Actual variable type can be added here
DECLARE_OCVarTempChange(BOOL)
///------ End CENTRALIZE_CODE_ABOUT_OC_VARIABLE_TEMP_CHANGE

///------ Folger 10/13/2010 ORG-1210-S2 CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK
class DefaultTemplateTemporaryChange
{
public:
	DefaultTemplateTemporaryChange(LPCSTR lpcszTemplate, int nType)
	{
		m_nType = nType;
		DefaultTemplate(m_szOldDefaultTemplate, m_nType);
		DefaultTemplate((LPSTR)lpcszTemplate, m_nType, FALSE);
	}
	~DefaultTemplateTemporaryChange()
	{
		DefaultTemplate(m_szOldDefaultTemplate, m_nType, FALSE);
	}
protected:
private:
	int		m_nType;
	char	m_szOldDefaultTemplate[MAXLINE];
};
///------ End CREATE_NEW_TABLE_OBJ_FOR_FITTER_OPERATION_IF_WKS_WITHIN_HAS_NO_LINK

//--------------------------
///Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY
/*
class XFDLGButtonEnables
{
public:
	XFDLGButtonEnables(DWORD* pdwEnable)
	{
		m_pdwEnable = pdwEnable;
		if(m_pdwEnable)
		{
			m_bOKEnable = (*m_pdwEnable & GETNGEVT_OK_ENABLE);
			m_bBTN1Enable = (*m_pdwEnable & GETNGEVT_ENABLE_CUSTOM_BUTTON1);
			m_bBTN2Enable = (*m_pdwEnable & GETNGEVT_ENABLE_CUSTOM_BUTTON2);
			m_bBTN3Enable = (*m_pdwEnable & GETNGEVT_ENABLE_CUSTOM_BUTTON3);
		}
	}
	~XFDLGButtonEnables()
	{
		*m_pdwEnable = 0;
		if(m_bOKEnable)
			*m_pdwEnable |= GETNGEVT_OK_ENABLE;
		if(m_bBTN1Enable)
			*m_pdwEnable |= GETNGEVT_ENABLE_CUSTOM_BUTTON1;
		if(m_bBTN2Enable)
			*m_pdwEnable |= GETNGEVT_ENABLE_CUSTOM_BUTTON2;
		if(m_bBTN3Enable)
			*m_pdwEnable |= GETNGEVT_ENABLE_CUSTOM_BUTTON3;
	}
private:
	DWORD* 	m_pdwEnable;
public:
	bool 	m_bOKEnable;
	bool 	m_bBTN1Enable;
	bool 	m_bBTN2Enable;
	bool 	m_bBTN3Enable;
};
*/
//-----------------------
///End ENABLE_CUSTOM_BUTTONS_SEPARATELY

#define PBOX_NO_BUTTON		0x0200 // no cancel or end button, cannot click to cancel
#define PBOX_OFF_CENTER		0x0400
#define PBOX_TOPMOST		0x0800	// place progressBox as the topmost window, always in front of other windows from all processes
#define PBOX_NO_BAR			0x2000	// just dialog with title and label, no progress bar and buttons
#define	PBOX_ENDBUTTON		0x4000	// instead of Cancel button
#define PBOX_NO_LT_BREAK	0x8000	// LT break 1 command can close a progressBox, so use this bit to prevent that if the loop might execute LT scripts that might have break 1 inside
enum {PBOXT_TITLE, PBOXT_MIDCENTER, PBOXT_TOPLEFT};
// Please note that Origin C is not yet a full C++ language. Only internal classes
// can be declared as C++ classes. User C++ classes can only be supported via
// user supplied DLL.

#define PBOX_DEFAULT_STYLE	0x0000	/// Kenny 12/24/2009 QA81-14875-P2 PROGRESS_BAR_IN_BUILTIN_TOOL_SHOULD_NOT_KEEP_TOPMOST

/**+
http://ocwiki.originlab.com/index.php?title=Category:progressBox_(class)
*/
class progressBox
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:progressBox-progressBox
	*/
	progressBox(LPCSTR lpcszLabel, int nStyle = 0, BOOL bHide = false);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:progressBox-SetRange
	*/
	BOOL	SetRange(int nMin, int nMax);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:progressBox-Set
	*/
	BOOL	Set(int nCurrent);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:progressBox-SetText
	*/
	BOOL	SetText(LPCSTR lpcszText, int nPosition = PBOXT_TITLE);
	
 	///---Sim 04-18-2007 FIX_PROGRESS_CANCEL_ISSUE
 	/**+
_	http://ocwiki.originlab.com/index.php?title=OriginC:progressBox-IsAbort
 	*/
	BOOL	IsAbort();
 	///---END FIX_PROGRESS_CANCEL_ISSUE

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:ProgressBox-CheckReopen
	*/
	///------ Folger 11/10/09 OC_PROGRESSBAR_NEEDS_SUPPORT_REOPEN
	BOOL	CheckReopen();
	///------ End OC_PROGRESSBAR_NEEDS_SUPPORT_REOPEN
 	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:progressBox-m_nCurrent
	*/
	int		m_nCurrent;
};


/**+
http://ocwiki.originlab.com/index.php?title=Category:waitCursor_(class)
*/
class waitCursor
{
public:
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:waitCursor-waitCursor
	*/
	waitCursor();
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:waitCursor-waitCursor
	*/
	waitCursor(int nCursorType);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:waitCursor-CheckEsc
	*/
	BOOL CheckEsc();
};

///////////////////////
#pragma dll(msvcrt, system)

//Comments last updated by HF on 3/15/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:malloc_(global_function)
*/
void *	malloc(UINT nBytes); // Allocates a certain number of bytes on heap.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:calloc_(global_function)
*/
void *	calloc(UINT nElements, UINT nSize);

///Sophy 7/6/2010 ADD_STANDARD_CLIB_API
/**$
*/
void *	realloc(void* pmem, UINT nBytes);
///end ADD_STANDARD_CLIB_API
//Comments last updated by HF on 3/15/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:free_(global_function)
*/
void	free(void * pmem);  // Deallocates or frees a memory block that was allocated with malloc or calloc.

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:atoi_(global_function)
*/
int		atoi(LPCSTR lpcsz);  //Converts string to an integer.

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:atol_(global_function)
*/
long	atol(LPCSTR lpcsz);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:_getcwd_(global_function)
*/
char*	_getcwd( char *buffer, int maxlen );// get the current working path

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:_chdir_(global_function)
*/
int		_chdir( const char *lpcszPath ); // change the current working directory to the specified path


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:_getdrive_(global_function)
*/
int		_getdrive( ); // get the current working drive

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:_chdrive_(global_function)
*/
int		_chdrive( int drive ); // change the current working drive



// Origin internal functions
// all function prototypes from here on must be implemented from within the Origin OUTL DLL
#pragma dll(@OUTL)
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:file_compare_(global_function)
*/
int file_compare(LPCSTR lpcszFilename1, LPCSTR lpcszFilename2, uint* pnDiff1stbyte = NULL);

// Origin internal functions
// all function prototypes from here on must be implemented from within the Origin OK DLL

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:memory_replace_(global_function)
*/
int memory_replace(LPSTR lpBuff, int nSize, LPSTR chOldList, int nOldListSize, char chNew);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:systemtime_to_date_str_(global_function)
*/
BOOL systemtime_to_date_str(SYSTEMTIME *pSysTime, LPSTR lpstr, WORD wFormat=LDF_SHORT);



#if  _OC_VER > 0x0703
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SystemTimeToJulianDate_(global_function)
*/
BOOL SystemTimeToJulianDate(double *lpdDate, SYSTEMTIME *lpSysTime);

/**#
	get the string for given plot designation
	Example1:
	// This is a self contained sample program for the function systemtime_to_date_str, 
	// To run the program, enter the following command in the Script window:
	//   get_plot_designation_str_ex1;
	// When it runs, it will print the following messages:
	//   Disregard:	Desig#=0 DesigStr="D"
	//   X:         Desig#=1 DesigStr="X"
	//   Y:         Desig#=2 DesigStr="Y"
	//   Z:         Desig#=3 DesigStr="Z"
	//   Label:     Desig#=4 DesigStr="L"
	//   XError:    Desig#=5 DesigStr="xEr"
	//   YError:    Desig#=6 DesigStr="yEr"
	//
	void get_plot_designation_str_ex1()
	{
		#define nBuffSize 50
		char Buffer[nBuffSize];
		int nPlotDesignation;
		
		get_plot_designation_str(COLDESIG_NONE,Buffer,nBuffSize);
		printf("  Disregard:\tDesig#=%d DesigStr=\"%s\"\n",COLDESIG_NONE,Buffer);

		get_plot_designation_str(COLDESIG_X,Buffer,nBuffSize);
		printf("  X:\tDesig#=%d DesigStr=\"%s\"\n",COLDESIG_X,Buffer);

		get_plot_designation_str(COLDESIG_Y,Buffer,nBuffSize);
		printf("  Y:\tDesig#=%d DesigStr=\"%s\"\n",COLDESIG_Y,Buffer);

		get_plot_designation_str(COLDESIG_Z,Buffer,nBuffSize);
		printf("  Z:\tDesig#=%d DesigStr=\"%s\"\n",COLDESIG_Z,Buffer);		

		get_plot_designation_str(COLDESIG_LABEL,Buffer,nBuffSize);  
		printf("  Label:\tDesig#=%d DesigStr=\"%s\"\n",COLDESIG_LABEL,Buffer);		

		get_plot_designation_str(COLDESIG_XERROR,Buffer,nBuffSize);  
		printf("  XError:\tDesig#=%d DesigStr=\"%s\"\n",COLDESIG_XERROR,Buffer);

		get_plot_designation_str(COLDESIG_YERROR,Buffer,nBuffSize);		
		printf("  YError:\tDesig#=%d DesigStr=\"%s\"\n",COLDESIG_YERROR,Buffer);
	}

	Parameters:
		nPlotDesignation = [input] the number of the plot designation. 
		  The following mnemonics can be used:
		  COLDESIG_NONE, COLDESIG_X, COLDESIG_Y, COLDESIG_Z,
		  COLDESIG_LABEL, COLDESIG_XERROR, COLDESIG_YERROR, etc.
		  Also, see add_plots_to_layer .
		lpBuffer = [output] pointer to the buffer to receive the designation string
		nBuffSize = [output] size of the buffer
	Returns:
		If successful then TRUE else FALSE
*/
BOOL get_plot_designation_str(int nPlotDesignation, LPSTR lpBuffer, int nBuffSize);

/**#
	convert Column(n).GetType() return values which are in the enum of OKDATAOBJ_DESIGNATION_Y
	return COLDESIG_Y enums
	Example1:
		void cvt_col_type_to_designation_ex1()
		{
			int nRet = cvt_col_type_to_designation(OKDATAOBJ_DESIGNATION_Y);
			out_int("",nRet);
		}
*/
int cvt_col_type_to_designation(int nColType);

/**#
*/
LPSTR	get_plot_dataset_ptr(DataPlotStrings* pDS, int nDesignation); //---- CPY 6/18/05 QA70-7820 DATA_PLOT_INFO_AND_LOOSE_DATASET_SUPPORT

/**#
*/
//int		ConvertPlotIds(int nType, DWORD* pdwCntrl);
int		ConvertPlotIds(int nType, DWORD* pdwCntrl, DWORD *pdwLTPlotInfo = NULL);




/**#
*/
int get_base_plot_type(int nPlotType);
/**#
	Compare the two given plot types and return 1 if they are compatible, returns 0 if not
*/
int compare_plot_types(int nPlotType1, int nPlotType2);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:check_add_file_ext_(global_function)
*/
BOOL check_add_file_ext(LPSTR lpszFilename, LPCSTR lpcszExt, LPSTR lpszExt2 = NULL);

/// Comments last updated by Joseph on 08/10/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_system_font_info_(global_function)
*/
BOOL  get_system_font_info(int nType, int* lpnFontSize, byte* lpnCharSet, LPSTR lpszFontName, int nNameSize);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:str_to_date_custom_(global_function)
*/
BOOL str_to_date_custom(LPCSTR lpcszDateStr, LPCSTR lpcszFormatStr, double* pDate);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:date_to_str_custom_(global_function)
*/
BOOL date_to_str_custom(double rDate, LPCSTR lpcszFormatStr, LPSTR lpszDateStr);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:str_to_time_(global_function)
*/
double str_to_time(LPCTSTR lpcszTime, DWORD dwFlags=0);

#endif //#if  _OC_VER > 0x0703

#if		_OC_VER >= 0x0800


/// Comments last updated by Joseph on 08/10/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:parse_data_range_str_(global_function)
*/
BOOL parse_data_range_str(LPCSTR lpcszRangeString, LPSTR lpszBookName, LPSTR lpszSheetName, LPSTR lpszR1, LPSTR lpszC1, LPSTR lpszR2, LPSTR lpszC2);

/// EJP 2005-02-28 v8.0198 QA70-7433 IMPORT_CSV_FILES
//Comments last updated by Iris 7/29/2008, added $
/**$ >Character and String Manipulation
		Get a pointer to the next term in the string.
	Parameters:
		lpszOutput =[output] the buffer that will receive the current term
		lpszInput = [output] the string to search in
		cDelimiter = the term delimiter
	Returns:
		A pointer to the next term if found else NULL if end of string reached.
	Example1:
		void next_quoted_term_ex1()
		{
			char szOutput[100]; // 100 is just a safe number for the test string.
			char szInput[] = "\"A \"\"B\"\" C\",A B C,\"red,green,blue\"";
			LPSTR lpszNext = szInput;
		
			printf("szInput = %s\n", szInput);
			do
			{
				lpszNext = next_quoted_term(szOutput, lpszNext, ',');
				printf("szOutput = %s\nlpszNext = %s\n", szOutput, lpszNext);
			} while( lpszNext && *lpszNext );
		}
*/
LPSTR next_quoted_term(LPSTR lpszOutput, LPSTR lpszInput, char cDelimiter);
/// end IMPORT_CSV_FILES

/// AW 09/15/06 QA80-8978 v8.0483 MAKE_HELP_ID_FOR_XF_CHM
/**$
	Get the HelpID from the provided HelpID header file. HeldID used in making and call CHM file.
Examples:
	void testHelpID()
	{
		string strTemp(GetOriginPath() + "XFHelpID.h");
		int nHelpID = get_help_id(strTemp, "smooth");
	}
*/
int get_help_id(LPCSTR lpcszXFHelpIDFileName, LPCSTR lpcszXFname); 
/// END MAKE_HELP_ID_FOR_XF_CHM

/**	#
*/
HWND set_LT_script_window(HWND hWnd);


//--- CPY 6/28/2009 QA70-11650 RVD_6_26_09_NEW_SCALE_AXIS_WORK_BROKE_OC
//double        real_space(double x, BYTE space);
//double        real_inv_space(double x, BYTE space);
//---
#endif //#if		_OC_VER >= 0x0800


#pragma dll(@OK)

//--- CPY 6/28/2009 QA70-11650 RVD_6_26_09_NEW_SCALE_AXIS_WORK_BROKE_OC
/**#
*/
double        real_space(double x, int space);
/**#
*/
double        real_inv_space(double x, int space);
//--- end RVD_6_26_09_NEW_SCALE_AXIS_WORK_BROKE_OC

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LT_evaluate_(global_function)
*/
BOOL	LT_evaluate(LPCSTR lpcszLabTalkExpression, double * lpdbResult);


//Comments last updated by HF on 3/17/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LT_execute_(global_function)
*/
///------ Folger 12/11/09 QA81-14831-P1 LT_USE_OC_GETN_SUPPRESS_ERROR_WHEN_USER_CANCEL
//BOOL	LT_execute(LPCSTR lpcszLabTalkStr, int wCntrl = 0);
BOOL	LT_execute(LPCSTR lpcszLabTalkStr, int wCntrl = 0, int* pnErr = NULL);
///------ End LT_USE_OC_GETN_SUPPRESS_ERROR_WHEN_USER_CANCEL

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LT_get_var_(global_function)
*/
BOOL	LT_get_var(LPCSTR lpcszLabTalkVarName, double * lpdbResult);  // Get LabTalk variable value

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LT_set_var_(global_function)
*/
BOOL	LT_set_var(LPCSTR lpcszLabTalkVarName, double dbValue);	// Set LabTalk variable value

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LT_get_str_(global_function)
*/
BOOL	LT_get_str(LPCSTR lpcszLabTalkString, char* pBuffer, int nBufferSize); // Get LabTalk string


// Comments last updated by Joseph on 09/11/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LT_set_str_(global_function)
*/
BOOL	LT_set_str(LPCSTR lpcszVar, LPCSTR lpcszContent); // Set LabTalk string	variable



/// ML 1/13/2006 XVARIABLEBASE_TO_VC
/**$
return CCS_LTVAR_SUBSTITUDED if LT str variable and converted
return CCS_QUOTE_REMOVED if quoted and quotes removed
return CCS_ERR_LTVAR_NOT_FOUND if $ ended but not found to be LT str variable
return CCS_NO_CHANGE if no change, either because not ended with $ and bCheckLTstrVarOnlyIfDollarEnded=false, or bCheckLTstrVarOnlyIfDollarEnded but not ended with $ and not a LT str variable
*/
int		check_cvt_str(LPCSTR lpcszVal, string *pstr, bool bCheckLTstrVarOnlyIfDollarEnded = true);
/// end XVARIABLEBASE_TO_VC

///------ Folger 07/14/10 ORG-518-P10 PROPER_ERROR_REPORT_FOR_FFW_QUICK_CHECK
/**$
*/
BOOL	LT_get_last_err(char* pBuffer, int nBufferSize);
///------ End PROPER_ERROR_REPORT_FOR_FFW_QUICK_CHECK


// these are defined in oc_tyeps.h
//#define AIC_LISTCTRL_SETNUMCOLS		1
//#define AIC_LISTCTRL_SETCELL			2
//#define AIC_LISTCTRL_DELROW			3
//#define AIC_LISTCTRL_ADDROW			4
// when uMsg = AIC_LISTCTRL_SET_GET_COL_TYPE, the function will set or get the types of the column;
// lp1 should be the column number, lp2 should be the type one want to set, lp3 = 0 means to get, else
// lp3 = 1 means to set; 
//the types are as following:
// NUMERIC           0
// TEXT              1
// TIME              2
// DATE              3
// MONTH             4
// DAY_OF_WEEK       5
// TEXT_NUMERIC  	 6

/**#
*/
int AscImpListCtrlMsg(LPCSTR lpcstrName, UINT uMsg, UINT lP1 = 0, UINT lP2 = 0, UINT lP3 = 0);

/**#
*/
int AscImpListCtrlInsRow(LPCSTR lpcstrName, StringArray *psa, int iRow=-1, BOOL bAddCol=TRUE);

//------ CPY 9/24/02 v7.0404 QA70-2658 ASCII_IMPORT_FROM_OC
// requires Origin 7 SR3 or later
//Comments last updated by Jospeh 08/10/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:AscImpReadFileStruct_(global_function)
*/
int AscImpReadFileStruct(LPCSTR lpcszFilename, ASCIMP* pASCIMPstruct, DWORD dwCntrl=0);

// OLE Automation Object and COM support is only available only for OriginPro versions, or with a special COM enabled license.

#ifdef	ORIGIN_COM_SUPPORT
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CreateObject_(global_function)
*/
Object	CreateObject(LPCSTR lpcszObjectName); // Create an automation (COM) object.

// Comments last updated by Joseph on 09/11/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetEventHandlerForObject_(global_function)
*/
int		SetEventHandlerForObject(Object *pObj, LPCSTR lpcszEventName, Function *pOCFunc);

//Comments last updated by Joseph on 9/11/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetCOMObjectProperties_(global_function)
*/
BOOL GetCOMObjectProperties(Object *pObj, TreeNode *ptr, BOOL bExcludeArrayElement = TRUE);
#endif //#ifdef	ORIGIN_COM_SUPPORT

//Comments last updated by HF on 3/17/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:InputBox_(global_function)
*/
string InputBox(LPCSTR lpcszMsg, LPCSTR lpcszDeault = NULL, DWORD dwOption = 0); //Opens a simple input box for entering a string.

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetDecimalChar_(global_function)
*/
char GetDecimalChar();

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetHexDump_(global_function)
*/
string GetHexDump(const LPVOID lpcMemory, int nSize, BOOL bAddGap=TRUE);

// Comments last updated by Joseph on 05/22/2007
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetOriginPath_(global_function)
*/
string GetOriginPath(int nPathType = ORIGIN_PATH_SYSTEM, bool bCheckExistsAndDiffFromUserPath = false);

// Comments last updated by Joseph on 05/22/2007
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetAppPath_(global_function)
*/
string GetAppPath(BOOL bServerPath = FALSE);

//Comments last updated by HF on 3/23/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetDataDisplayText_(global_function)
*/
BOOL SetDataDisplayText(LPCTSTR lpcszText);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetDataDisplay_(global_function)
*/
void SetDataDisplay(int nValType, int nVal);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetDataDisplay_(global_function)
*/
BOOL GetDataDisplay(int nValType);

// Comments last updated by Frank on 08/08/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:SetStatusBarText_(global_function)
*/
BOOL SetStatusBarText(LPCSTR lpcszText, int nIndex = 0);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FindFile_(global_function)
*/
BOOL FindFile(LPCTSTR lpcszName, LPSTR lpPath, LPCTSTR lpSubFolder1st = NULL, BOOL bExcluded = TRUE);

///Comments last updated by Joseph 09/11/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DefaultTemplate_(global_function)
*/
int DefaultTemplate(LPSTR lpname, int nType, BOOL bGet = true, BOOL bAddExt = false);

/// Comments last updated by Joseph on 05/22/2007
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFullPath_(global_function)
*/
string GetFullPath(LPCSTR lpcszFileName, LPCSTR lpSubPath = NULL, BOOL bLocalized=FALSE);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFilePath_(global_function)
*/
string GetFilePath(LPCSTR lpcszFullPathFileName);

//Comments last updated by HF on 3/23/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFileName_(global_function)
*/
string GetFileName(LPCSTR lpcszFullPathFileName, BOOL bRemoveExt=FALSE);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:CheckMakePath_(global_function)
*/
BOOL CheckMakePath(LPCSTR lpcszFullPath);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:RenameFile_(global_function)
*/
BOOL RenameFile(LPCSTR lpcszNewFilename, LPCSTR lpcszOldFilename);

#if  _OC_VER > 0x0703

/// Comments last updated by Joseph on 05/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFontName_(global_function)
*/
string GetFontName(int nID, int* plfHeight);

///Kyle 05/04/2010 QA80-15378 OC_FUNCTION_TO_CONVERT_BETWEEN_FONT_INDEX_AND_DWORD
// dwCtrl is for now not used
int FontFaceDWORD_to_Index(DWORD dw, DWORD dwCtrl = 0);

// dwCtrl is for now not used
DWORD FontFaceIndex_to_DWORD(int nIndex, DWORD dwCtrl = 0);
///End OC_FUNCTION_TO_CONVERT_BETWEEN_FONT_INDEX_AND_DWORD

/// Comments last updated by Joseph on 05/22/2007
/**# >System
*/
uint GetOriginClipboardFormat(int nType = 0);

/// Comments last updated by Joseph on 05/22/2007
/**# >System
*/
BOOL CopyThemeFromClipboard(LPCSTR lpcszFilename);

/// Comments last updated by Joseph on 05/22/2007
/**# >System
*/
BOOL	ApplyFilterToTheme(LPCSTR lpcszSourceThemePathName, LPCSTR lpcszDestinationPathName, DWORD dwPropertiesFilter, DWORD dwObjectsFilter);


/// ML 4/28/2006 FRIENDLY_CUSTOM_TABLE_THEME_GENERATION
/**$
*/
BOOL	MakeCustomTableTheme(TreeNode *ptrTheme, LPCSTR lpcszInputPathName, TreeNode *ptrReport);
/// end FRIENDLY_CUSTOM_TABLE_THEME_GENERATION


// Comments last updated by Frank on 08/08/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_date_str_(global_function)
*/
string	get_date_str(double dDateTime, WORD wFormat = LDF_SHORT_AND_HHMMSS_SEPARCOLON);

///Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
/**#
*/
string	get_time_str(double dDateTime, WORD wFormat = 0);
///end SUPPORT_FIND_X_AS_DATE_TIME_FORMAT


///DSC 2/08/2010 DEL_OCTEMP_WHEN_INSTALL_MODULE_DEVELOPERKIT_LIC
/**$
*/
int	on_lic_module_add(LPCSTR lpcszModuleName, LPCSTR lpcszLicFile = NULL, DWORD dw = 0);
///end DEL_OCTEMP_WHEN_INSTALL_MODULE_DEVELOPERKIT_LIC

/// ML 2/12/2010 QA70-15113 FORMAT_MENU_UPDATE_ON_INSTALLING_OMC
/**$
*/
int		on_install_omc(LPCSTR lpcszOMC);
/// end FORMAT_MENU_UPDATE_ON_INSTALLING_OMC


//Comments last updated by HF on 3/29/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetRegKey_(global_function)
*/
string GetRegKey(BOOL bLanguage = TRUE);  //get the registry key in the general area for the Origin software

// Last updated by Sim 08-02-2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:OptionalMessage_(global_function)
*/
int	OptionalMessage(LPCSTR lpcszMessage, int iBtnOpts, LPCSTR lpcszAuxStr = NULL);

///Kyle 09/18/2009 QA80-14216 GET_OPTIONAL_MESSAGE_STATUS
/**#
		Get user's last choice for the message box.
	Parameters:
		lpcszMessage
			[input]Keyword for the text of the message.
	Returns:
		user choice if user closed the message box with "Do not show this message again" checking, can be one of: OM_RETURN_YNC_CANCEL, OM_RETURN_OK, OM_RETURN_CANCEL, OM_RETURN_YES, OM_RETURN_NO;
		Otherwise OM_RETURN_NOT_PRESENT.
	Example:
*/
int	OptionalMessageStatus(LPCSTR lpcszMessage);
///End GET_OPTIONAL_MESSAGE_STATUS

/// Comments last updated by Joseph on 05/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetProjectAttachedFilesPath_(global_function)
*/
string GetProjectAttachedFilesPath();

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ExecuteApp_(global_function)
*/
BOOL ExecuteApp(LPCSTR lpApp, LPCSTR lpArg, BOOL bTransferControl = TRUE, BOOL bTryWinExec = FALSE);


/**#
		get name of a data plot from Origin's internal plot ID
	Parameters:
		nPlotType = plot type
		dwAuxPlotInfo = auxiliary plot info.
	Returns:
		plot type name
	Example:
*/
string  GetPlotTypeName(int nPlotType, DWORD dwAuxPlotInfo = 0, DWORD dwLTPlotInfo = 0);
/**#
	Parameters:
		lpcsz = [input]English string
		
	Returns:
		original string if running in English OS, otherwised return localized string
	Example:
*/
string  GetLocalized(LPCSTR lpcsz, LPCSTR lpcszCategory = NULL);
#define _L(_STR)	GetLocalized(_STR) // use this for all literal strings that should be localized	
#define _LC(_STR, _CAT)	GetLocalized(_STR, _CAT)	// must define _CATEGORY at the beginning of the file


/**#
	It handles '|'-separated string.
*/
string  GetLocalizedEx(LPCSTR lpcsz, LPCSTR lpcszCategory = NULL, DWORD dwCtrl = 0);

//----- CPY 10/23/2007 QA70-10577 COMBO_STR_STAY_AS_E_INTERNALLY_IN_DYNA_CNTRL
//#define _LB(_STR)	GetLocalizedEx(_STR)		// for bitwise-separated string
#define _LE(_STR)	GetLocalizedEx(_STR,NULL,1)		// for | separated str and return English
//-----

//----- CPY 11/05/2007 QA70-10598 OC_OUTPUT_ALLOW_LANGUAGE_CONTROL
// _L : used in OC only, return value is always localized
// _LE: used in OC only, return English but add to oLocal
// _LL: used in OC AND VC, return value is always localized
// _LR: used in OC only, return value is dependent on @ setting to be either English or localized
#define _LL(_STR)	GetLocalized(_STR) // use this for all literal strings that should be localized	
#define _LR(_STR)	GetLocalized(_STR) // will define this later to allow @ var control
//-----	

/**#
	Parameters:
		lpcszInOut =[input] intput theme file, and will be the combined file name
		lpcszIn = [input]second intput theme file 
		
	Returns:
		TRUE if successfully combined themes, otherwise FALSE
	Example:
*/
BOOL	CombineThemes(LPCSTR lpcszInOut, LPCSTR lpcszIn);

/// Comments last updated by Joseph on 05/22/2007
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_temp_path_(global_function)
*/
int get_temp_path(LPSTR lpBuffer, int nBufferSize);

// Comments last updated by Frank on 08/08/2005
//Category last updated by Iris 7/29/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:RoundLimits_(global_function)
*/
int RoundLimits(double* pmin, double* pmax, double* pinc, int nSteps = 8, BOOL bLogScale = FALSE);

/// EJP 2007-06-15 v8.0642 QA70-9897 ROUND_LIMTS_AND_BINS
///Kyle 03/03/2009 QA80-13149 RoundBinningRange_SUPPORT_SPECIFYING_INCREMENT, replace bRoundToMinorTick with dwCntrl
//Category last updated by Iris 7/29/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:RoundBinningRange_(global_function)
*/
BOOL RoundBinningRange(double* pmin, double* pmax, int nSteps, int nSpace, double* pinc, DWORD dwCntrl = 0);
/// end ROUND_LIMTS_AND_BINS

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:DoubleToStr_(global_function)
*/
void DoubleToStr(double dbVal, LPSTR lpszOutput, int nOutputSize, LPCTSTR lpcszFormat); //Convert a double value into a string using LabTalk formating notation

///DSC 8/8/05 QA70-7973 EXPORT_CVT_STR_TO_DOUBLE_AS_ATOF moved to ok from msvcrt
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:atof_(global_function)
*/
double	atof(LPCSTR lpcsz, BOOL bAllowUnits = false);  // Converts string to a double.
///end EXPORT_CVT_STR_TO_DOUBLE_AS_ATOF

#endif //_OC_VER > 0x0703

#if		_OC_VER >= 0x0800

/**#
		It parses the range string.
	Returns:
		the total number of ranges found if successful, otherwise it returns a negative number.
*/
int		ParseRangeString(LPCSTR lpcszString,
							vector<int> *pvectUIDs,
							vector<int> *pvectR1s,
							vector<int> *pvectC1s,
							vector<int> *pvectR2s,
							vector<int> *pvectC2s);
/**#
*/

string	GetRangeDescription(TreeNode* pRangeTree);

/// EJP 05-19-2004 v7.5875 QA70-6426 GET_LICENSE_INFO_FROM_OC
#define LIC_USERINFO_NAME_COMPANY_MAXLEN	255
#define LIC_OTHER_INFO_MAXLEN				100
// Comments last updated by Frank on 08/08/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetLicenseInfo_(global_function)
*/
DWORD GetLicenseInfo(LPSTR lpszRegUserName=NULL, LPSTR lpszCompany=NULL, LPSTR lpszSN=NULL, LPSTR lpszRegCode=NULL);
/// end GET_LICENSE_INFO_FROM_OC

/**#
	Get user information, like serial number.
*/
int GetUserInfo(stWCBUSERINFO *pUserInfo, BOOL bEncoded = FALSE );




/// TD 6-2-04 QA70-5875 GENERAL_LISTBOX_IN_OC
// Comments last updated by Frank on 08/08/2005
/**# >User Interface
	Creates a Dialog box with a list conatining all the choices
	Parameters:
		pvsChoices =[input] array containing choices
		lpcszTitle =[input] Title of the choice dialog: can use "\r\n" delimit to add a name for the list box
		nDefault = [input]The value returned if clicked OK before selecting any
		pCheckBox =[input] if not null a check box will appear at the bottom of the list box, on return 
							-- on OK *pCheckBox is (TRUE/FALSE = Checked/Unchecked)
							-- on cancel *pCheckBox value is unchanged
		lpcszCheckBoxMsg =[input] the text that appears next to the checkbox
	Returns:
		returns the index of the selected item(nDefault if nothing is selected) on OK
		returns -1 on cancel
	Example1:
	#define NUM_CHOICES 5
	void ListInputBox_ex1()
	{
		vector<string> strChoices;
		strChoices.SetSize(NUM_CHOICES);
		string strChoice;
		for(int ii = 0; ii < NUM_CHOICES; ii++)
		{
			strChoice.Format("Choice%d", ii);
			strChoices[ii] = strChoice;
		}
		int nCheckBox = -2;
		
		int naval = ListInputBox(&strChoices, "Selection Box\r\nPlease select",-2, &nCheckBox, "Plese Check if ...");

	}
*/
int ListInputBox(vector<string>* pvsChoices, LPCSTR lpcszTitle, int nDefault = 0, BOOL* pCheckBox= NULL, LPCSTR lpcszCheckBoxMsg = NULL);

// Comments last updated by Frank on 08/08/2005
/**#
	Creates a Dialog box with a Radios for each choices
	Parameters:
		pvsChoices =[input] array containing choices
		lpcszTitle =[input] Title of the choice dialog: can use "\r\n" delimit to add a name for the list box
		nDefault = [input]The value returned if clicked OK before selecting any
		pCheckBox = [input]if not null a check box will appear at the bottom of the list box, on return 
							-- on OK *pCheckBox is (TRUE/FALSE = Checked/Unchecked)
							-- on cancel *pCheckBox value is unchanged
		lpcszCheckBoxMsg =[input] the text that appears next to the checkbox
	Returns:
		returns the index of the selected item(nDefault if nothing is selected) on OK
		returns -1 on cancel
	Example1:
	#define NUM_CHOICES 5
	void RadioInputBox_ex1()
	{
		vector<string> strChoices;
		strChoices.SetSize(NUM_CHOICES);
		string strChoice;
		for(int ii = 0; ii < NUM_CHOICES; ii++)
		{
			strChoice.Format("Choice%d", ii);
			strChoices[ii] = strChoice;
		}
		int nCheckBox = -2;
		
		int naval = RadioInputBox(&strChoices, "Selection Box\r\nPlease select",-2, &nCheckBox, "Plese Check if ...");

	}
*/
int RadioInputBox(vector<string>* pvsChoices, LPCSTR lpcszTitle, int nDefault = 0, BOOL* pCheckBox= NULL, LPCSTR lpcszCheckBoxMsg = NULL);
/// end GENERAL_LISTBOX_IN_OC

///Sophy 10/27/2010 ORG-1179 REMINDER_MESSAGE_FOR_SWTICHING_DATABASEIMPORTDLG
/**#
	Creates a reminder message box with a Radios for each choices
	Parameters:
		lpcszKey =[input] The Keyword the identify this kind of message
		lpcszTitleWithText =[input] Title of the choice dialog: can use "\r\n" delimit description for the choices
		pStringArray = [input] Labels for each choice item
		nDefault = [input] default selected item index, 0 offset.
		lpcszCheckBox =[input] the text that appears next to the checkbox, if null, checkbox will not be visible.
	Returns:
		returns the index of the selected item(nDefault if nothing is selected) on OK
		returns -1 on cancel
	Example1:
	#define NUM_CHOICES 5
	void RatioReminderMessage_ex1()
	{
		vector<string> vsChoices;
		vsChoices.SetSize(NUM_CHOICES);
		string strChoice;
		for(int ii = 0; ii < NUM_CHOICES; ii++)
		{
			strChoice.Format("Choice%d", ii);
			vsChoices[ii] = strChoice;
		}
		string strCheckBox = "Do not remind me any more.";
		
		int naval = RatioReminderMessage("MyRadioBox, "Select Box\r\nPlease select one item:",&vsChoices, 1, strCheckBox);

	}
*/
int	RatioReminderMessage(LPCSTR lpcszKey, LPCSTR lpcszTitleWithText, vector<string>* pStringArray, int nDefault = 0, LPCSTR lpcszCheckBox = NULL);
///end REMINDER_MESSAGE_FOR_SWTICHING_DATABASEIMPORTDLG

/// AW 09/23/04 QA80-6953 GENERAL_COMBOBOX_IN_OC
// Comments last updated by Frank on 08/08/2005
/**# >User Interface
	Creates a Dialog box with a Combobox conatining all the choices
	Parameters:
		pvsChoices =[input] array containing choices
		lpcszDefault =[input] str to be in Edit box
		lpcszMsg = [input]str in msg box above EditCombo
		lpcszTitle =[input] Title of the dialog
	Returns:
		returns result string of combobox.
	Example1:
	void ComboInputBox_ex1()
	{
		vector<string> strChoices;
		strChoices.SetSize(3);
		string strChoice;
		for(int ii = 0; ii < 3; ii++)
		{
			strChoice.Format("Choice%d", ii);
			strChoices[ii] = strChoice;
		}
		string strTitle = "Test ComboInput";
		string strMeg = "Some Text here to explain the purpose";
		string strResult = "default";
		try {
			strResult = ComboInputBox(&strChoices, strResult, strMeg, strTitle);
		}
		catch(int nErr)
		{
			strResult = "User Cancel";
		}
			
		out_str(strResult);
	}
*/
string ComboInputBox(vector<string>* pvsChoices, LPCSTR lpcszDefault, LPCSTR lpcszMsg, LPCSTR lpcszTitle = NULL);
/// END GENERAL_COMBOBOX_IN_OC

/// Comments last updated by Joseph on 05/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetLTMathFunctionList_(global_function)
*/
int GetLTMathFunctionList(vector<string>* psaNames, vector<string>* psaDescriptions, vector<uint>* pvuNumArgs, vector<string>* psaInsert);

/// Comments last updated by Joseph on 05/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetOCMathFunctionList_(global_function)
*/
int GetOCMathFunctionList(vector<string>* psaNames, vector<string>* psaDescriptions, vector<uint>* pvuNumArgs, vector<string>* psaInsert);


/// ML 9/15/2004 QA70-5770 QA70-6878 ANALYSIS_MENUS_OC_HANDLING
/**#
*/
string	GetOperationClassName(UINT nID, int *pnOption);
/// end ANALYSIS_MENUS_OC_HANDLING

/// SY 11/09/2004 QA70-7066 v8.0161 EXPORT_TOOLBARS_BUTTONS_INTO_OPK
// Comments last updated by Frank on 08/08/2005
/**$
		Save toolbars and buttons info into a ini file
	Example1:
	Parameters:
		lpcszINIFilename = [input] ini file which to store the toolbars and buttons infor
	Return:
		true when success, else false.
*/
BOOL SaveToolbarSettings(LPCSTR lpcszINIFilename);
/// end EXPORT_TOOLBARS_BUTTONS_INTO_OPK

/**$
*/
BOOL		UpdateThemesMenuItems(LPCSTR lpcszName);



/// ML 3/18/2008 QA70-10598 FORCE_REPORT_TO_ENGLISH
/**#
		It can be used to temporarily switch the language to English for the purpose of creating report in English.
		The behavior is based on the value of the system variable @RLS. If its value is 0 (LANGSWITCHSYS_NONE), the function will do nothing.
		If its value is 1 (LANGSWITCHSYS_ENG_ALWAYS), it can temporarily switch the language internally to English.
	Parameters:
		msg=one of the following values:
			enum {
				LANGSWITCH_GET_SYSVAR						= 1,	// returns the value of the system variable @RLS
				LANGSWITCH_SET_SYSVAR,								// sets the value of the system variable @RLS (supplied in nParam).
				LANGSWITCH_BEFORE_RUN_FIRST_TIME,					// should be called before calling the code which generates the report. It returns the previous language value
				LANGSWITCH_BEFORE_RECALC,							// not used
				LANGSWITCH_RESTORE,									// should be called to restore the original language. nParam should contain the return value from the LANGSWITCH_BEFORE_RUN_FIRST_TIME call.
			};
		nParam=used by LANGSWITCH_SET_SYSVAR and LANGSWITCH_RESTORE (see above).
	Returns:
		the previous value of the language for LANGSWITCH_BEFORE_RUN_FIRST_TIME.
*/
int			LanguageSwitch(UINT msg, int nParam = 0);
/// end FORCE_REPORT_TO_ENGLISH

///------ Folger 12/17/08 QA80-12749 v8.0987d PLOT_MRU_LIST_SHOULD_UPDATE_THAT_PLOTS_IN_TEMPLATE_LIBRARY
/**#
*/
BOOL		UpdatePlotMRUTemplateItem(LPCSTR lpcszTemplateFile, int nPlotType = EXIST_WKS);
///------ End PLOT_MRU_LIST_SHOULD_UPDATE_THAT_PLOTS_IN_TEMPLATE_LIBRARY

///------ Folger 02/26/10 QA81-14568-P2 CHANGE_UFF_BETTER_ERROR_CHECKING
/**#
*/
BOOL		CheckUFF(LPCSTR lpcszPath, BOOL bAllowMessages = TRUE, BOOL bCreate = TRUE, string* pstrMessage = NULL);
///------ End CHANGE_UFF_BETTER_ERROR_CHECKING

///------ Folger 06/12/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
/**#
*/
BOOL		UpdateDataInfoWindow(int nPlotUID = 0, int nIndex = -1);
///------ End ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT

#endif		// _OC_VER >= 0x0800

////////////////////////////////////////////////////////////////////
#endif //_UTILITIES_H
